//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
namespace Polymorphism
{
	class Character
	{
		String value;
		public Character()
		{
			value = "null";
		}
		public Character(String value)
		{
			this.value = value;
		}
		public virtual void Output()
		{
			Console.WriteLine("Jestem znakiem {0}", value);
		}
	}
	class Letter : Character
	{
		public Letter(String value) : base(value)
		{
		}
		public override void Output()
		{
			Console.Write("Jestem liter i ");
			base.Output();
		}
	}
	class Number : Character
	{
		public Number(String value) : base(value)
		{
		}
		public override void Output()
		{
			Console.Write("Jestem liczb i ");
			base.Output();
		}
	}

	class CharacterOutput 
	{
		public static void Main(String[] args)
		{
			Character [] c = new Character [] { new Letter("A"),
												new Letter("B"),
												new Letter("C"),
												new Number("1"),
												new Number("2"),
												new Number("3") };
				// Wyliczenie tablicy argumentw wiersza polece.
				for(int i = 0; i < c.Length; ++i)
					c[i].Output();
		}
	}
}
